# Webhook Auto-Reconnect System

## Overview
This system ensures your Telegram bot webhook stays connected 24/7 and automatically reconnects if it gets disconnected.

## Protection Layers

### 1. Built-in Auto-Reconnect (basic_bot.php)
- **Automatic**: Checks webhook status every 5 minutes
- **Non-blocking**: Runs in background, doesn't slow down bot responses
- **Auto-fix**: Automatically reconnects if webhook is missing or has errors
- **No setup required**: Works automatically once deployed

### 2. Webhook Keeper (webhook_keeper.php)
- **Standalone script**: Can be run independently via cron job
- **Comprehensive checks**: Verifies webhook URL, errors, and accessibility
- **Logging**: Saves all events to `webhook_keeper.log`
- **Manual testing**: Can be tested via browser or cron

## Setup Instructions

### Automatic (Recommended)
The built-in protection works automatically - no setup needed!

### Enhanced Protection (Optional)
For maximum reliability, set up a cron job:

1. **Access your server via SSH**
2. **Edit crontab**: `crontab -e`
3. **Add this line** (replace URL with your domain):
   ```
   */5 * * * * curl -s "https://yourdomain.com/webhook_keeper.php?silent=1" > /dev/null 2>&1
   ```
3. **Save and exit**: The cron job will run every 5 minutes

### Manual Testing
- Visit `setup.php` in your browser
- Click "🧪 Test Keeper" to test webhook keeper
- Click "🔄 Reconnect Webhook" to manually reconnect
- Click "📊 Check Status" to view current webhook status

## How It Works

### Detection
The system detects webhook disconnections by checking:
- ✅ Webhook URL is set
- ✅ Webhook URL matches expected URL
- ✅ No recent errors (within last hour)
- ✅ Webhook endpoint is accessible
- ✅ Pending updates count is reasonable

### Auto-Reconnect
When a problem is detected:
1. Verifies webhook URL is accessible
2. Reconnects webhook with optimal settings:
   - Keeps pending updates
   - Sets allowed update types
   - Increases max connections to 40
3. Logs the action for monitoring

## Monitoring

### View Logs
- **Webhook Keeper Log**: `webhook_keeper.log` (if cron is set up)
- **Setup Page**: Visit `setup.php` to see last 20 log lines
- **Status Check**: Use "📊 Check Status" button

### Status Indicators
- 🟢 **Active**: Webhook is healthy
- 🟡 **Active (URL Mismatch)**: URL doesn't match expected
- 🟡 **Active (Recent Error)**: Error occurred within last hour
- 🟡 **Active (High Pending Updates)**: More than 100 pending updates
- 🔴 **Not Set**: Webhook is not configured

## Troubleshooting

### Webhook Keeps Disconnecting
1. Check server uptime and SSL certificate
2. Verify webhook URL is accessible from internet
3. Check `webhook_keeper.log` for error messages
4. Ensure cron job is running (if set up)

### Manual Reconnect
1. Visit `setup.php`
2. Click "🔄 Reconnect Webhook"
3. Check status to verify reconnection

### Test Webhook Keeper
1. Visit `setup.php`
2. Click "🧪 Test Keeper"
3. Review the output for any issues

## Files

- `basic_bot.php` - Main bot with built-in auto-reconnect
- `webhook_keeper.php` - Standalone webhook monitoring script
- `setup.php` - Setup and management interface
- `webhook_keeper.log` - Log file (created automatically)

## Best Practices

1. **Use HTTPS**: Always use HTTPS for webhook URLs
2. **Set up Cron**: Add cron job for extra protection
3. **Monitor Logs**: Check logs regularly for issues
4. **Keep Server Online**: Ensure server has good uptime
5. **Valid SSL**: Keep SSL certificate valid and up-to-date

## Technical Details

### Webhook Settings
- **Max Connections**: 40 (allows more concurrent requests)
- **Allowed Updates**: `message`, `callback_query` (only what's needed)
- **Drop Pending**: `false` (keeps pending updates)

### Check Interval
- **Built-in**: Every 5 minutes (300 seconds)
- **Cron Job**: Every 5 minutes (recommended)
- **Manual**: Anytime via setup.php

## Support

If webhook continues to disconnect:
1. Check server logs
2. Verify SSL certificate
3. Test webhook URL accessibility
4. Review `webhook_keeper.log`
5. Contact hosting provider if server issues persist

