# REDLINE Telegram Bot - Independent Version

A complete, independent Telegram bot for REDLINE with all features and easy deployment on any domain.

## 🚀 Features

- **Complete Bot Functionality** - Start, product selection, payments, confirmations
- **6 Crypto Payment Options** - Bitcoin, Ethereum, USDT ERC20, Litecoin, USDT BEP20, Tron
- **REDLINE.png Image Support** - Shows image when available
- **Custom Webhook URLs** - Deploy on any domain or folder
- **Independent Configuration** - Easy to customize and deploy

## 📁 Files

- `basic_bot.php` - Main bot file (working perfectly)
- `config.php` - Configuration file (API token, addresses, messages)
- `setup.php` - Setup script with webhook controls
- `REDLINE.png` - Bot image file
- `README.md` - This file

## ⚙️ Setup Instructions

### 1. Upload Files
Upload all files to your web server (root folder or any subfolder).

### 2. Configure Bot
Edit `config.php` to customize:
- Bot token
- Payment addresses
- Pricing
- Messages

### 3. Set Webhook
Visit `setup.php` in your browser:
- Click "✅ Enable Webhook" for automatic setup
- Or use "Custom Webhook URL" for specific paths

### 4. Test Bot
- Open Telegram and find your bot
- Send `/start` command
- Test all buttons and navigation

## 🔧 Configuration

### Bot Token
```php
$BOT_TOKEN = 'YOUR_BOT_TOKEN_HERE';
```

### Payment Addresses
```php
$PAYMENT_ADDRESSES = [
    'btc' => 'your_bitcoin_address',
    'eth' => 'your_ethereum_address',
    // ... etc
];
```

### Pricing
```php
$PRICING = [
    'week' => 160,
    'month' => 400,
    'quarter' => 1000,
    'stealer_2months' => 300,
    'stealer_pro' => 700
];
```

## 🌐 Deployment Options

### Root Folder
- Upload files to root
- Webhook: `https://yourdomain.com/basic_bot.php`

### Subfolder
- Upload files to subfolder (e.g., `/bots/`)
- Webhook: `https://yourdomain.com/bots/basic_bot.php`

### Custom Domain
- Upload files to any domain
- Use custom webhook URL in setup.php

## 📱 Bot Features

### Main Menu
- 🚀 Start button with REDLINE.png image
- 🔥 Private REDLINE Logs Cloud
- 💉 REDLINE Stealer

### Payment Options
- ₿ Bitcoin
- Ξ Ethereum  
- 💎 USDT ERC20
- Ł Litecoin
- 💎 USDT BEP20
- 🔺 Tron

### Plans
- 🕒 1 Week - $160
- 📅 1 Month - $400
- ⏰ 3 Month - $1000
- 🕒 2 Months Plan - $300
- 👑 PRO Plan (LIFETIME) - $700

## 🛠️ Setup.php Features

- ✅ Enable Webhook
- ❌ Disable Webhook
- 📊 Check Status
- 🔗 Custom Webhook URL
- 📋 Examples and instructions

## 🔒 Security

- All payment addresses are configurable
- Bot token is in config file
- No hardcoded sensitive data
- Easy to update and maintain

## 📞 Support

The bot is completely independent and ready to use on any domain. Just upload the files, configure the settings, and set the webhook!

## 🎯 Quick Start

1. **Upload files** to your server
2. **Edit config.php** with your bot token and addresses
3. **Visit setup.php** and enable webhook
4. **Test your bot** in Telegram

That's it! Your REDLINE bot is ready to use! 🚀
